import swal from "sweetalert2";
import axios from "axios";

let appUrl = document.querySelector("#ctx").getAttribute("content");

$( document ).ready(function() {
    $('#category').change(function (){
        showLoading('Loading Users...', 'Please wait while we load the data')
        let url  = '/admin/permissions/getSupportedRights';
        var id = $(this).val();
        require('axios-debug-log')
        axios.get(url, {
            params: {
                'categoryId' : id,
            }
        })
        .then(function (response) {
            console.log('Response:', response);
            closeLoading()
            let option ="";
            $.each(response.data, function(key, item){
                option += '<option value="' + item.name +  '">' + item.name  + '</option> ';
            });
            $('#access').empty(); //remove all child nodes
            var newOption = option;
            $('#access').append(newOption);
            $('#access').trigger("chosen:updated"); 
            if ($('#supportedRight').val() !=""){
                $('#access').val($('#supportedRight').val());
            }
        })
        .catch(function (error) {
            showPrompt('Something went wrong',
                'There was an error processing you request, if you believe\
                    this is a bug, please contact our team')
            closeLoading()
        })
           
    });
    $('#category').trigger('change'); 
});