<?php

use Illuminate\Database\Seeder;
use App\Models\PermissionGroup;

class PermissionGroupsTableSeeder extends Seeder
{
    /**
     * Run the database seeds.
     *
     * @return void
     */
    public function run()
    {
        \DB::table('permission_groups')->truncate();

        PermissionGroup::create([
            'code' => 'USER',
            'value' => 'Users',
            'description' => 'Access to User Management',
            'create_by' => 'Seeder',
            'status' => 'A',
            'supported_rights' => 'R,W,A,D',
        ]);

        PermissionGroup::create([
            'code' => 'ROLES',
            'value' => 'Roles',
            'description' => 'Access to Roles Module',
            'create_by' => 'Seeder',
            'status' => 'A',
            'supported_rights' => 'R,W,A,D',
        ]);

        PermissionGroup::create([
            'code' => 'PERMISSIONS',
            'value' => 'Permissions',
            'description' => 'Access to Permissions Module',
            'create_by' => 'Seeder',
            'status' => 'A',
            'supported_rights' => 'R,W,A,D',
        ]);

        PermissionGroup::create([
            'code' => 'DROPBOX',
            'value' => 'Dropbox',
            'description' => 'Access to Dropbox Accounts Module',
            'create_by' => 'Seeder',
            'status' => 'A',
            'supported_rights' => 'R,W,A,D',
        ]);
    }
}
