<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class AlterVideoRoomsAddShippingInformation extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        if (!Schema::hasColumn('video_rooms', 'shipped_date')) {
            Schema::table('video_rooms', function (Blueprint $table) {
                $table->date('shipped_date')->nullable();
            });
        }
        if (!Schema::hasColumn('video_rooms', 'shipped_time')) {
            Schema::table('video_rooms', function (Blueprint $table) {
                $table->time('shipped_time')->nullable();
            });
        }
        if (!Schema::hasColumn('video_rooms', 'shipped_by')) {
            Schema::table('video_rooms', function (Blueprint $table) {
                $table->string('shipped_by',100)->nullable();
            });
        }
        if (!Schema::hasColumn('video_rooms', 'shipping_label_company')) {
            Schema::table('video_rooms', function (Blueprint $table) {
                $table->string('shipping_label_company',100)->nullable();
            });
        }
        if (!Schema::hasColumn('video_rooms', 'shipping_company')) {
            Schema::table('video_rooms', function (Blueprint $table) {
                $table->string('shipping_company',100)->nullable();
            });
        }
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        if (Schema::hasColumn('video_rooms', 'shipped_date')) {
            Schema::table('video_rooms', function (Blueprint $table) {
                $table->dropColumn('shipped_date');
            });
        }
        if (Schema::hasColumn('video_rooms', 'shipped_time')) {
            Schema::table('video_rooms', function (Blueprint $table) {
                $table->dropColumn('shipped_time');
            });
        }
        if (Schema::hasColumn('video_rooms', 'shipped_by')) {
            Schema::table('video_rooms', function (Blueprint $table) {
                $table->dropColumn('shipped_by');
            });
        }
        if (Schema::hasColumn('video_rooms', 'shshipping_label_companyipped_date')) {
            Schema::table('video_rooms', function (Blueprint $table) {
                $table->dropColumn('shipping_label_company');
            });
        }
        if (Schema::hasColumn('video_rooms', 'shipping_company')) {
            Schema::table('video_rooms', function (Blueprint $table) {
                $table->dropColumn('shipping_company');
            });
        }
    }
}
