<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class AlterVideoRecordingsAddStatus extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        if (!Schema::hasColumn('video_room_recordings', 'status')) {
            Schema::table('video_room_recordings', function (Blueprint $table) {
                $table->string('status',20)->default(0);
            });
        }
        if (!Schema::hasColumn('video_room_recordings', 'url')) {
            Schema::table('video_room_recordings', function (Blueprint $table) {
                $table->string('url',120)->default(0);
            });
        }
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        if (Schema::hasColumn('video_room_recordings', 'status')) {
            Schema::table('video_room_recordings', function (Blueprint $table) {
                $table->dropColumn('status');
          
            });
        }
        if (Schema::hasColumn('video_room_recordings', 'url')) {
            Schema::table('video_room_recordings', function (Blueprint $table) {
                $table->dropColumn('url');
          
            });
        }
    }
}
