<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class AlterVideoRoomsAddHasRecording extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        if (!Schema::hasColumn('video_rooms', 'has_recording')) {
            Schema::table('video_rooms', function (Blueprint $table) {
                $table->boolean('has_recording')->default(0);
            });
        }
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        if (Schema::hasColumn('video_rooms', 'has_recording')) {
            Schema::table('video_rooms', function (Blueprint $table) {
                $table->dropColumn('has_recording');
            });
        }
    }
}
