<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class AlterCalendarActivitiesAddIsPublic extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        if (!Schema::hasColumn('calendar_activities', 'is_private')) {
            Schema::table('calendar_activities', function (Blueprint $table) {
                $table->integer('is_private')->default(0);
            });
        }
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        if (Schema::hasColumn('calendar_activities', 'is_private')) {
            Schema::table('calendar_activities', function (Blueprint $table) {
                $table->dropColumn('is_private')->default(0);
            });
        }
    }
}
