<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class AlterCalendarActivitiesAddColor extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        if (!Schema::hasColumn('calendar_activities', 'color')) {
            Schema::table('calendar_activities', function (Blueprint $table) {
                $table->string('color')->nullable();
            });
        }
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        if (Schema::hasColumn('calendar_activities', 'color')) {
            Schema::table('calendar_activities', function (Blueprint $table) {
                $table->dropColumn('color');
            });
        }

    }
}
