<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class AlterUsersAddLocationSkillsExperience extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        if (!Schema::hasColumn('users', 'skills')) {
            Schema::table('users', function (Blueprint $table) {
                $table->string('skills')->nullable();
            });
        }

        if (!Schema::hasColumn('users', 'location')) {
            Schema::table('users', function (Blueprint $table) {
                $table->string('location')->nullable();
            });
        }

        if (!Schema::hasColumn('users', 'experience')) {
            Schema::table('users', function (Blueprint $table) {
                $table->text('experience')->nullable();
            });
        }

        if (!Schema::hasColumn('users', 'job_title')) {
            Schema::table('users', function (Blueprint $table) {
                $table->string('job_title')->nullable();
            });
        }

        if (!Schema::hasColumn('users', 'education')) {
            Schema::table('users', function (Blueprint $table) {
                $table->string('education')->nullable();
            });
        }
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        if (Schema::hasColumn('users', 'skills')) {
            Schema::table('users', function (Blueprint $table) {
                $table->dropColumn('skills');
            });
        }

        if (Schema::hasColumn('users', 'location')) {
            Schema::table('users', function (Blueprint $table) {
                $table->dropColumn('location');
            });
        }

        if (Schema::hasColumn('users', 'experience')) {
            Schema::table('users', function (Blueprint $table) {
                $table->dropColumn('experience');
            });
        }

        if (Schema::hasColumn('users', 'job_title')) {
            Schema::table('users', function (Blueprint $table) {
                $table->dropColumn('job_title');
            });
        }

        if (Schema::hasColumn('users', 'education')) {
            Schema::table('users', function (Blueprint $table) {
                $table->dropColumn('education');
            });
        }
    }
}
