<?php

use Illuminate\Support\Facades\Schema;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Migrations\Migration;

class CreateEmailOnQueues extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('email_on_queues', function (Blueprint $table) {
            $table->increments('id');
            $table->text('subject')->nullable();
            $table->text('template')->nullable();
            $table->text('parameters')->nullable();
            $table->text('email_address')->nullable();
            $table->string('create_by',20)->nullable();
            $table->integer('is_sent')->nullable();
            $table->dateTime('sent_date')->nullable();
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('email_on_queues');
    }
}
