<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class AlterTableRoleAddGroupCode extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        if (!Schema::hasColumn('roles', 'group_code')) {
            Schema::table('roles', function (Blueprint $table) {
                $table->string('group_code')->nullable();
            });
        }
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        if (Schema::hasColumn('roles', 'group_code')) {
            Schema::table('roles', function (Blueprint $table) {
                $table->dropColumn('group_code');
            });
        }
    }
}
