<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class AlterTableUsersAddLoginnameGroupCode extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        if (!Schema::hasColumn('users', 'login_name')) {
            Schema::table('users', function (Blueprint $table) {
                $table->string('login_name')->nullable();
            });
        }

        if (!Schema::hasColumn('users', 'group_code')) {
            Schema::table('users', function (Blueprint $table) {
                $table->string('group_code')->nullable();
            });
        }

        if (!Schema::hasColumn('users', 'sec_code')) {
            Schema::table('users', function (Blueprint $table) {
                $table->string('sec_code')->nullable();
            });
        }
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        if (Schema::hasColumn('users', 'login_name')) {
            Schema::table('users', function (Blueprint $table) {
                $table->dropColumn('login_name');
            });
        }

        if (Schema::hasColumn('users', 'group_code')) {
            Schema::table('users', function (Blueprint $table) {
                $table->dropColumn('group_code');
            });
        }

        if (Schema::hasColumn('users', 'sec_code')) {
            Schema::table('users', function (Blueprint $table) {
                $table->dropColumn('sec_code');
            });
        }
    }
}
