<?php

namespace App\Services\Admin;

use App\Contracts\Admin\UserActionService;
use App\Models\EmailOnQueue;
use App\Models\Permission;
use App\Models\User;
use App\Services\BaseServiceImpl;
use Carbon\Carbon;
use Illuminate\Support\Facades\DB;


class UserActionServiceImpl extends BaseServiceImpl implements UserActionService
{
    public function listUsers()
    {
        $access = session('allUserAccesses')['users'];
        $users = User::where('status','<>','D')->get();
        $message="'Delete this User?'";
        $messageReset="'Reset password for this User?'";
        $result = array();
        foreach ($users as $user)
        {

            if($user->status==User::USER_ACTIVE){
                $status = '<span class="badge badge-success">Active</span>';
            } else {
                $status = '<span class="badge badge-warning">Inactive</span>';
            }
            $view = ' <a class="btn btn-primary btn-sm" href="/admin/users/'.$user->id.'">
                            <i class="fa fa-folder">
                            </i>
                            View
                        </a>';
            $edit = ' <a class="btn btn-success btn-sm" href="/admin/users/'.$user->id.'/edit">
                        <i class="fa fa-pencil">
                        </i>
                        Edit
                    </a>';
            $delete = ' <a class="btn btn-danger btn-sm" href="/admin/users/'.$user->id.'/delete"  onclick="return confirm('.$message.')">
                    <i class="fa fa-trash">
                    </i>
                    Delete
                </a>';
            $reset = ' <a class="btn btn-info btn-sm" href="/admin/users/'.$user->id.'/reset"  onclick="return confirm('.$messageReset.')">
                <i class="fa fa-recycle">
                </i>
                Reset
            </a>';

            //check access
            if (!Permission::canView($access)) $view="";
            if (!Permission::canEdit($access)) $edit="";
            if (!Permission::canDelete($access)) $delete="";
            if (!Permission::canReset($access)) $reset="";

            $result[] = array(
                $user->id,
                $user->first_name,
                $user->last_name,
                $user->email,
                $user->mobile_number,
                $status,
                $view.' '. $edit.' '.$delete. ' '.$reset
            );
        }

        $resultObject = (object) [
            'users' => $result
        ];

        return $resultObject;
    }

    public function createEmailOnQueue($params)
    {
        $emailOnQueue = new EmailOnQueue;
        $emailOnQueue->subject = $params['subject'];
        $emailOnQueue->template =   $params['template'];
        $emailOnQueue->parameters =   $params['parameters'];
        $emailOnQueue->email_address =  $params['email_address'];
        $emailOnQueue->create_by = auth()->user()->username;
        $emailOnQueue->is_sent = 0;
        $emailOnQueue->sent_date = null;
        $emailOnQueue->save();
    }
}
