<?php

namespace App\Providers;

use Illuminate\Support\ServiceProvider;
use Illuminate\Support\Facades\Response;
use Illuminate\Support\Facades\Schema;
use Illuminate\Support\Facades\URL;

class AppServiceProvider extends ServiceProvider
{
    /**
     * Register any application services.
     *
     * @return void
     */
    public function register()
    {
        //
    }

    /**
     * Bootstrap any application services.
     *
     * @return void
     */
    public function boot()
    {
        if (env('APP_ENV') === 'production') {
            URL::forceScheme('https');
        }
        Schema::defaultStringLength(191);

        //macros
        Response::macro('success', function ($data)
        {
            return response()->json([
                'success' => true,
                'data' => $data
            ]);
        });

        Response::macro('failed', function ($error, $statusCode)
        {
            return response()->json([
                'success' => false,
                'error' => $error
            ], $statusCode);
        });
    }
}
