<?php

namespace App\Http\Controllers;


use App\Contracts\Report\ReportActionService;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;

use App\Exports\SessionReportExport;
use Maatwebsite\Excel\Facades\Excel;
use Carbon\Carbon;

class ReportController extends Controller
{
    public function __construct(ReportActionService $reportActionService)
    {
        $this->reportActionService = $reportActionService;
    }

    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function sessionReport()
    {
        return view('report.index');
    }

    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function getSessionReport(Request $request)
    {
        $resultObject = $this->reportActionService->listSessionData($request);
        return response()->json($resultObject->video);
    }

    /**
     * Export data to excel.
     */
    public function export(Request $request)
    {
        $now = Carbon::now()->format('mdYHis');
        $datefrom = Carbon::parse($request->hiddenDateFrom)->format('Y-m-d');
        $dateto = Carbon::parse($request->hiddenDateTo)->addDays(1)->format('Y-m-d');

        return (new SessionReportExport($datefrom, $dateto))->download('sessionReport_'.$now.'.xlsx');
    }

}
