<?php

namespace App\Http\Controllers\Admin;

use App\Contracts\Admin\RoleActionService;

use App\Http\Controllers\Controller;
use App\Models\PermissionRole;
use App\Models\Role;
use Illuminate\Http\Request;

class RoleController extends Controller
{

    protected $roleActionService;
    
    public function __construct(RoleActionService $roleActionService)
    {
        $this->middleware('access:roles,create|view|delete|edit')->only('index');
        $this->middleware('access:roles,view')->only('show');
        $this->middleware('access:roles,edit')->only('edit');
        $this->middleware('access:roles,delete')->only('delete');
        $this->middleware('access:roles,create')->only('create');
        $this->roleActionService = $roleActionService;
    }
    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function index()
    {
        return view('admin.roles.index');
    }

    /**
     * Show the form for creating a new resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function create()
    {
        $permissionGroups = collect($this->roleActionService->getPermissions());
        //dd($permissionGroups);
        return view('admin.roles.create',compact('permissionGroups'));
    }

    /**
     * Store a newly created resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */
    public function store(Request $request)
    {
        $this->validate($request, [
            'role' => 'required',
            'description' => 'required',
            'access' => 'required',
        ]);

        $role = new Role;
        $role->name = $request->input('role');
        $role->remark = $request->input('description');
        $role->created_at = date('Y-m-d H:i:s');
        $role->create_by = auth()->user()->username;
        $role->update_by = '';
        $role->status = 'A';
        $role->save();

        $accesses = substr($request->access, 0, strlen($request->access) - 1);
        $accesses = explode(",", $accesses);
        foreach($accesses as $access) {      
            $permissionRole = new PermissionRole;
            $permissionRole->permission_id = $access;
            $permissionRole->role_id = $role->id;
            $permissionRole->save(); 
        }

        return redirect('/admin/roles')->with('success','Role was successfully added');
    }

    /**
     * Display the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function show($id)
    {
        $role = Role::find($id);
        $permissionGroups = collect($this->roleActionService->getPermissions());
        $accesses = PermissionRole::where('role_id',$id)->get();
        $resource_id="";
        foreach($accesses as $access) {
            $resource_id .= $access->permission_id .",";
        }
        if(strlen($resource_id) >0){
            $resource_id = substr($resource_id, 0, strlen($resource_id) - 1);
        }
        $role_access = explode(',', $resource_id);
        return view('admin.roles.show',compact('permissionGroups','role','role_access')); 
    }

    /**
     * Show the form for editing the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function edit($id)
    {
        $role = Role::find($id);
        $permissionGroups = collect($this->roleActionService->getPermissions());
        $accesses = PermissionRole::where('role_id',$id)->get();
        $resource_id="";
        foreach($accesses as $access) {
            $resource_id .= $access->permission_id .",";
        }
        if(strlen($resource_id) >0){
            $resource_id = substr($resource_id, 0, strlen($resource_id) - 1);
        }
        $role_access = explode(',', $resource_id);
        return view('admin.roles.edit',compact('permissionGroups','role','role_access')); 
    }

    /**
     * Update the specified resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function update(Request $request, $id)
    {
        $this->validate($request, [
            'role' => 'required',
            'description' => 'required',
            'access' => 'required',
        ]);

        $role = Role::find($id);
        $role->name = $request->input('role');
        $role->remark = $request->input('description');
        $role->created_at = date('Y-m-d H:i:s');
        $role->create_by = auth()->user()->username;
        $role->update_by = '';
        $role->status = 'A';
        $role->save();
        
        PermissionRole::where('role_id', $id)->delete();
        $accesses = substr($request->access, 0, strlen($request->access) - 1);
        $accesses = explode(",", $accesses);
        foreach($accesses as $access) {      
            $permissionRole = new PermissionRole;
            $permissionRole->permission_id = $access;
            $permissionRole->role_id = $role->id;
            $permissionRole->save(); 
        }

        return redirect('/admin/roles')->with('success','Role was successfully updated');
    }

    /**
     * Remove the specified resource from storage.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function delete($id)
    {
        
        $role = Role::find($id);
        $role->status = 'D';
        $role->save();

        return redirect('/admin/roles')->with(['success' => 'Role was successfully deleted']);
    }

    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function getData(Request $request)
    {
        $resultObject = $this->roleActionService
            ->listRoles();
        return response()->json($resultObject->roles);
    }

}
