<?php

namespace App\Http\Controllers\API;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;

use App\Contracts\Video\VideoActionService;
use App\Models\VideoRoom;

class VideoController extends Controller
{
    protected $videoActionService;

    public function __construct(VideoActionService $videoActionService)
    {
        $this->videoActionService = $videoActionService;
    }

    public function createRoom(Request $request)
    {
        try {
            
            $this->validate($request,[
                'mobileNumber' => 'required_without:emailAddress',
                'emailAddress' => 'required_without:mobileNumber',
            ]);

            $video = $this->videoActionService->createRoom($request); 
            if ($video->success)
            {
                return response()->success($video);
            } else {
                return response()->failed('Encountered error while attempting to create room. Please try again.');     
            }
        } catch (\Exception $e) {

            return response()->failed($e->getMessage(),404);
            
        }
    }

    public function getShippingInfo(Request $request)
    {
        try {
            
            $this->validate($request,[
                'sessionId' => 'required',
            ]);

            $video = VideoRoom::select('shipped_date','shipped_time','shipped_by'
                                        ,'shipping_label_company','shipping_company')
                    ->where('room_id',$request->sessionId)->first(); 
            if (isset($video->shipped_date))
            {
                $resultObject = (object) [
                    'shipped_date' => $video->shipped_date,
                    'shipped_time' => $video->shipped_time,
                    'shipped_by' => $video->shipped_by,
                    'shipping_label_company' => $video->shipping_label_company,
                    'shipping_company' => $video->shipping_company,
                ];
                return response()->success($resultObject);
            } else {
                return response()->failed('Session not found. Please check your session id and try again.',404);     
            }

        } catch (\Exception $e) {

            return response()->failed($e->getMessage(),404);
            
        }
    }

    public function createContact(Request $request)
    {
        try {
            
            $this->validate($request,[
                'fullName' => 'required',
                'referenceId' => 'required',
            ]);

            $video = $this->videoActionService->createContact($request); 
            if ($video->success)
            {
                return response()->success($video);
            } else {
                return response()->failed('Encountered error while attempting to create room. Please try again.');     
            }
        } catch (\Exception $e) {

            return response()->failed($e->getMessage(),404);
            
        }
    }

    public function createRoomEmail(Request $request)
    {
        try {
            
            $this->validate($request,[
                'emailAddress' => 'required',
            ]);

            $video = $this->videoActionService->createRoomEmail($request); 
            if ($video->success)
            {
                return response()->success($video);
            } else {
                return response()->failed('Encountered error while attempting to create room. Please try again.');     
            }
        } catch (\Exception $e) {

            return response()->failed($e->getMessage(),404);
            
        }
    }
}
