<?php

namespace App\Exports;

use App\Models\VideoRoom;
use Maatwebsite\Excel\Concerns\FromQuery;
use Maatwebsite\Excel\Concerns\Exportable;
use Maatwebsite\Excel\Concerns\WithHeadings;
use Maatwebsite\Excel\Concerns\WithMapping;
use Carbon\Carbon;

class SessionReportExport implements FromQuery, WithHeadings, WithMapping
{
    use Exportable;

    public function __construct($from, $to)
    {
        $this->from = $from;
        $this->to = $to;
    }

    public function query()
    {
        return VideoRoom::query()->whereBetween('created_at', [$this->from, $this->to]);
    }

    public function map($video): array
    {
        return [
            [
                $video->id,
                $video->room_id,
                ($video->mobile_number != "")? $video->mobile_number: $video->email,
                Carbon::parse($video->created_at)->format('M d, Y h:i a'),
                Carbon::parse($video->updated_at)->format('M d, Y h:i a')
            ]
        ];
    }

    public function headings(): array
    {
        return [
            '#',
            'Room',
            'Mobile/Email',
            'Session Start',
            'Sesssion End',
        ];
    }

}
