<?php

namespace App\Contracts\Video;

use Illuminate\Http\Request;

interface VideoActionService
{

    /**
     * Get all videos
     *
     * @return mixed
     */
    public function getVideos();

    /**
     * Create Video Room
     */
    public function createRoom(Request $request);

    /**
     * Validate Max Participants
     */
    public function hasMaxParticipants($roomName);
    
    /**
     * Check room status 
     */
    public function isRoomClosed($roomName);

    /**
     * Disconnect participants
     */
    public function disconnectParticipants($roomName);

    /**
     * Download composition
     */
    public function downloadComposition($compositionSid);

    /**
     * Save Video Participant in DB
     */
    public function storeVideoParticipant($parameter);

    /**
     * Get Twilio Token
     */
    public function getTwilioToken();

    /**
     * Send SMS
     */
    public function sendSMS($parameter);

    /**
     * Send MMS
     */
    public function sendMMS($parameter);

    /**
     * Create Video Room
     */
    public function createContact(Request $request);
    
    /**
     * Create Video Room
     */
    public function createRoomEmail(Request $request);
}
