<?php

namespace App\Console\Commands;

use Illuminate\Console\Command;
use Illuminate\Support\Facades\Log;
use Illuminate\Support\Facades\Mail;
use GuzzleHttp\Client;
use Carbon\Carbon;
use App\Models\EmailOnQueue;

class ProcessEmailOnQueues extends Command
{
    /**
     * The name and signature of the console command.
     *
     * @var string
     */
    protected $signature = 'cron:processEmailOnQueues';

    /**
     * The console command description.
     *
     * @var string
     */
    protected $description = 'Send pending emails';

    /**
     * Create a new command instance.
     *
     * @return void
     */
    public function __construct()
    {
        parent::__construct();
    }

    /**
     * Execute the console command.
     *
     * @return mixed
     */
    public function handle()
    {
        Log::info('Started Process Email On Queue Cron');            
        $emailOnQueue = EmailOnQueue::where('is_sent', 0)->get();
        foreach ($emailOnQueue as $email) 
        {
            try {
                $message_id = "";
                $data = unserialize($email->parameters);
                Mail::send(['html'=>$email->template],$data, 
                    function($message) use ($email,&$message_id){
                        $message->to(explode(',',$email->email_address));
                        $message->subject($email->subject);
                        $message->from(env('MAIL_USERNAME','noreply@stratvideo.com'));
                        $message_id = $message->getId();
                    }
                );
                
                if (Mail::failures()) {
                    Log::error("Failed to process email! " . 
                        "Email On Queue ID: {$email->id} " .
                        "Email On Queue Address: {$email->address} " . 
                        "Email On Queue Subject: {$email->subject} " . 
                        "Email On Queue From: {$email->from} "
                    );
                } else {
                    Log::info("Successfully processed email with Email On Queue ID of {$email->id}");
                    $email->is_sent = 1;
                    $email->sent_date = date('Y-m-d H:i:s');
                    $email->save();
                }
            } catch (\Exception $ex) {
                Log::error("Failed to process email! " . 
                    "Email On Queue ID: {$email->id} " .
                    "Email On Queue Address: {$email->address} " . 
                    "Email On Queue Subject: {$email->subject} " . 
                    "Email On Queue From: {$email->from} " .
                    "Error Message: {$ex->getMessage()}"
                );
            }
            sleep(10); //10 seconds interval before sending another email to avoid spam issues
        }

        Log::info('End Process Email On Queue Cron');  
    }
}
