<?php

namespace App\Console\Commands;

use Illuminate\Console\Command;
use Illuminate\Support\Facades\Log;
use App\Models\VideoRecording;
use App\Models\VideoRoom;
use Twilio\Rest\Client;


class DownloadVideoRecordings extends Command
{
    /**
     * The name and signature of the console command.
     *
     * @var string
     */
    protected $signature = 'command:downloadVideoRecordings';

    /**
     * The console command description.
     *
     * @var string
     */
    protected $description = 'Download Video Room Recordings';

    /**
     * Create a new command instance.
     *
     * @return void
     */
    public function __construct()
    {
        parent::__construct();
        $this->sid = config('services.twilio.sid');
        $this->token = config('services.twilio.token');
        $this->key = config('services.twilio.key');
        $this->secret = config('services.twilio.secret');
    }

    /**
     * Execute the console command.
     *
     * @return mixed
     */
    public function handle()
    {
        Log::info('Started Downloading of Video Room Recordings');            
        $videoRooms = VideoRoom::where('has_recording', 0)->get();
        
        foreach ($videoRooms as $videoRoom) {
            $client = new Client($this->sid, $this->token);
            $recordings = $client->video->v1->recordings
            ->read([
                    "groupingSid" => [$videoRoom->room_id]
                ],
                20
            );
            foreach ($recordings as $record) {
                $composition = $client->video->compositions->create($videoRoom->room_id, [
                    'audioSources' => '*',
                    'videoLayout' =>  array(
                                        'grid' => array (
                                          'video_sources' => array('*')
                                        )
                                      ),
                    //'statusCallback' => 'http://my.server.org/callbacks',
                    'format' => 'mp4'
                ]);
                $recording = new VideoRecording();
                $recording->video_room_id = $videoRoom->id;
                $recording->room_id = $videoRoom->room_id;
                $recording->recording_id = $record->sid;
                $recording->link = $composition->links['media'];
                $recording->url = $composition->url;
                $recording->track_name = '';
                $recording->type = $composition->format;
                $recording->status = $composition->status;
                $recording->sid = $composition->sid;
                $recording->save();
            }
            if (count($recordings) > 0)
            {
                $room = VideoRoom::find($videoRoom->id);
                $room->has_recording = 1;
                $room->save();
            }
        }
        Log::info('Ended Downloading of Video Room Recordings'); 

    }
}
