<?php

namespace Database\Seeders;

use Illuminate\Database\Console\Seeds\WithoutModelEvents;
use Illuminate\Database\Seeder;
use App\Models\CallStatus;

class CallStatusesTableSeeder extends Seeder
{
    /**
     * Run the database seeds.
     */
    public function run(): void
    {
        \DB::table('call_statuses')->truncate();

        CallStatus::create([
            'description' => 'Secured an Appointment (SA)',
            'first_status_code' => 'C',
            'first_addi_code' => 'SA',
            'second_status_code' => '',
            'second_addi_code' => '',
            'status' => 'A',
        ]);
        
        CallStatus::create([
            'description' => 'Total Number of Client Follow-ups  (CL)',
            'first_status_code' => 'C',
            'first_addi_code' => 'CL',
            'second_status_code' => '',
            'second_addi_code' => '',
            'status' => 'A',
        ]);

        CallStatus::create([
            'description' => 'Deceased',
            'first_status_code' => 'C',
            'first_addi_code' => 'DE',
            'second_status_code' => 'DE',
            'second_addi_code' => '',
            'status' => 'A',
        ]);

        CallStatus::create([
            'description' => 'Disconnected',
            'first_status_code' => 'C',
            'first_addi_code' => 'D',
            'second_status_code' => 'D',
            'second_addi_code' => '',
            'status' => 'A',
        ]);

        CallStatus::create([
            'description' => 'Do Not Call',
            'first_status_code' => 'C',
            'first_addi_code' => 'DC',
            'second_status_code' => 'DNC',
            'second_addi_code' => '',
            'status' => 'A',
        ]);

        CallStatus::create([
            'description' => 'Fax',
            'first_status_code' => 'C',
            'first_addi_code' => 'FX',
            'second_status_code' => 'FX',
            'second_addi_code' => '',
            'status' => 'A',
        ]);

        CallStatus::create([
            'description' => 'Initial Refusal',
            'first_status_code' => 'C',
            'first_addi_code' => 'IR',
            'second_status_code' => '',
            'second_addi_code' => '',
            'status' => 'A',
        ]);

        CallStatus::create([
            'description' => 'Language Barrier',
            'first_status_code' => 'LB',
            'first_addi_code' => '',
            'second_status_code' => '',
            'second_addi_code' => '',
            'status' => 'A',
        ]);

        CallStatus::create([
            'description' => 'Not Qualified',
            'first_status_code' => 'C',
            'first_addi_code' => 'NQ',
            'second_status_code' => '',
            'second_addi_code' => '',
            'status' => 'A',
        ]);

        CallStatus::create([
            'description' => 'Refusal',
            'first_status_code' => 'C',
            'first_addi_code' => 'R',
            'second_status_code' => '',
            'second_addi_code' => '',
            'status' => 'A',
        ]);

        CallStatus::create([
            'description' => 'Wrong Number',
            'first_status_code' => 'C',
            'first_addi_code' => 'WN',
            'second_status_code' => 'WN',
            'second_addi_code' => '',
            'status' => 'A',
        ]);

        CallStatus::create([
            'description' => 'Agent Left Message',
            'first_status_code' => 'LM',
            'first_addi_code' => '',
            'second_status_code' => '',
            'second_addi_code' => '',
            'status' => 'A',
        ]);

        CallStatus::create([
            'description' => 'Answering Machine',
            'first_status_code' => 'A',
            'first_addi_code' => '',
            'second_status_code' => '',
            'second_addi_code' => '',
            'status' => 'A',
        ]);
        
        CallStatus::create([
            'description' => 'Busy',
            'first_status_code' => 'B',
            'first_addi_code' => '',
            'second_status_code' => '',
            'second_addi_code' => '',
            'status' => 'A',
        ]);

        CallStatus::create([
            'description' => 'General Callback',
            'first_status_code' => 'GC',
            'first_addi_code' => '',
            'second_status_code' => 'CB',
            'second_addi_code' => 'GC',
            'status' => 'A',
        ]);

        CallStatus::create([
            'description' => 'No Answer',
            'first_status_code' => 'N',
            'first_addi_code' => '',
            'second_status_code' => '',
            'second_addi_code' => '',
            'status' => 'A',
        ]);

        CallStatus::create([
            'description' => 'Dead Record',
            'first_status_code' => 'DR',
            'first_addi_code' => '',
            'second_status_code' => '',
            'second_addi_code' => '',
            'status' => 'A',
        ]);
        CallStatus::create([
            'description' => 'Duplicated Record',
            'first_status_code' => '',
            'first_addi_code' => '',
            'second_status_code' => '',
            'second_addi_code' => '',
            'status' => 'A',
        ]);
        CallStatus::create([
            'description' => 'Scheduled Callback',
            'first_status_code' => 'SC',
            'first_addi_code' => '',
            'second_status_code' => 'CB',
            'second_addi_code' => 'SC',
            'status' => 'A',
        ]);

        CallStatus::create([
            'description' => 'Not Qualified',
            'first_status_code' => 'C',
            'first_addi_code' => 'AH',
            'second_status_code' => '',
            'second_addi_code' => '',
            'status' => 'A',
        ]);

        CallStatus::create([
            'description' => 'Secured an Appointment (SA)',
            'first_status_code' => 'C',
            'first_addi_code' => 'TR',
            'second_status_code' => '',
            'second_addi_code' => '',
            'status' => 'A',
        ]);

    }
}
