<?php

namespace App\Http\Controllers;

use App\Models\User;
use Illuminate\Database\QueryException;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\DB;
use Illuminate\Support\Facades\Schema;
use Illuminate\Http\Response;
use Symfony\Component\HttpFoundation\StreamedResponse;

use App\Exports\DailyUnload;
use App\Exports\DailyReport;
use Maatwebsite\Excel\Facades\Excel;
use Illuminate\Support\Facades\Storage;

class CSVImportController extends Controller
{
    public function showImportForm()
    {
        return view('import'); // Create a view for the import form
    }

    public function import(Request $request)
    {
        // $request->validate([
        //     'recFile' => 'required|mimes:csv,txt',
        //     'detbFile' => 'required|mimes:csv,txt',
        //     'logFile' => 'required|mimes:csv,txt'
        // ]);

        $callDate = date("m/d/Y", strtotime($request->callDate));
        $files = array('recFile','detbFile','logFile');
        
        //truncate tables before importing new data
        $this->truncatePrimaryTables();
        

        //import files
        foreach ($files as $file)
        {
            if($request->file($file)!=null)
            {
                try {
                    $uploadFile = $request->file($file);
                    $tableName = $file.'_'.time();

                    if ($uploadFile->isValid()) {
                        //create table
                        $this->createTable($uploadFile, $tableName);

                        // Store the file temporarily to get the correct file path
                        $fileName = $uploadFile->getClientOriginalName();
                        $filePath = $uploadFile->storePubliclyAs('/public/uploads', $fileName);

                        // Get the full path
                        $fullPath = Storage::path($filePath);

                        // Escape backslashes and single quotes in the file path for use in SQL
                        //$escapedFilePath = addslashes($fullPath);

                        // Construct the LOAD DATA INFILE SQL statement
                        //$sql = "LOAD DATA INFILE '{$escapedFilePath}' INTO TABLE {$tableName} FIELDS TERMINATED BY ',' ENCLOSED BY '\"' LINES TERMINATED BY '\\n' IGNORE 1 LINES";

                        $escapedFilePath = str_replace('\\','/',$fullPath);
                        $sql="LOAD DATA LOCAL INFILE '{$escapedFilePath}' IGNORE";
                        $sql .=" INTO TABLE {$tableName}";
                        $sql .=" CHARACTER SET latin1 ";
                        $sql .=" FIELDS TERMINATED BY ','"; 
                        $sql .=" ENCLOSED BY '\"' "; 
                        $sql .=" LINES TERMINATED BY '\\n'";  
                        $sql .=" IGNORE 1 LINES";

                        // Execute the SQL statement
                        DB::unprepared($sql);

                        // Clean up: delete the temporary file
                        Storage::delete($filePath);
                        //return back()->with('success', 'CSV data loaded successfully.');
                    }
                   
                    if ($file == 'recFile')
                    {
                        $this->insertRecFile($tableName);
                    }
                    if ($file == 'detbFile')
                    {
                        $this->insertDetbFile($tableName);
                    }
                    if ($file == 'logFile')
                    {
                        $this->insertLogFile($tableName);
                    }

                } catch(QueryException $ex) {
                    dd($ex);//echo 'Assigned field/s not found. Kindly check file again';     die();
                }
            }
        }
        
        //cleanup tables after import
        $this->cleanUpTables();
        
        
        //export files
        $timestamp = now()->timestamp;    
        $dailyUnload = new DailyUnload($callDate);
        $dailyReport = new DailyReport($callDate);
        
        $dailyUnloadPath = 'exports/dailyUnload_'.$timestamp.'.xlsx';
        $dailyReportPath = 'exports/dailyReport_'.$timestamp.'.xlsx';

        Excel::store($dailyUnload,$dailyUnloadPath,'public');
        Excel::store($dailyReport,$dailyReportPath,'public');
    
        $dailyUnloadUrl = Storage::url($dailyUnloadPath);
        $dailyReportUrl = Storage::url($dailyReportPath);

        return view('download', [
            'dailyUnloadUrl' => $dailyUnloadUrl,
            'dailyReportUrl' => $dailyReportUrl,
        ]);
    }

    function truncatePrimaryTables()
    {
         //clean up primary tables
         $statement = "TRUNCATE TABLE cust_rec";
         DB::statement($statement);
 
         $statement = "TRUNCATE TABLE cust_detb";
         DB::statement($statement);
 
         $statement = "TRUNCATE TABLE cust_log";
         DB::statement($statement);
    }

    function cleanUpTables()
    {
        //remove test leads
        $statement = "DELETE FROM cust_rec WHERE RIGHT(cust_rec_id,3)='999'";
        DB::statement($statement);

        //clean statuses
        $statement = "DELETE FROM cust_rec WHERE status ='SP'";
        DB::statement($statement);

        $statement = "UPDATE cust_rec SET status = 'N' WHERE call_date <> '' AND status = 'NC'";
        DB::statement($statement);

        $statement = "UPDATE cust_rec SET addi_status= '' WHERE status <> 'C'";
        DB::statement($statement);

        //update call_notes
        $statement = "SET SESSION group_concat_max_len = 20000;";
        DB::statement($statement);

        $statement = "UPDATE cust_rec t1
                        JOIN (
                            SELECT cust_rec_id, GROUP_CONCAT(DISTINCT note ORDER BY note SEPARATOR '|') AS concatenated_details
                            FROM cust_detb WHERE note <> '' AND cust_rec_id <> ''
                            GROUP BY cust_rec_id
                        ) t2 ON t1.cust_rec_id = t2.cust_rec_id
                        SET t1.call_notes = CASE
                                        WHEN t1.call_notes = '' THEN t2.concatenated_details
                                        ELSE CONCAT(t1.call_notes, '|', t2.concatenated_details)
                                    END;"; 
        DB::statement($statement);
    }

    function insertRecFile($tableName)
    {
        $insertStatement = "INSERT INTO cust_rec (cust_rec_id,areacode,phone,sname,
                                                        address,city,state,zip,
                                                        zip4,status,addi_status,call_date,
                            tsr,attempt_counter,company,fax,
                            annual_sale,no_of_employee,title,sic_code,
                            sic_description,naics_code,naics_description,
                            callback_name2,gate_keeper,email_to,
                            appt_date,appt_time,appt_name,email_date_sent,
                            email_type,acw_actionitems,acw_conf_dm,call_notes,
                            created_at,updated_at) 
                            SELECT 
                            cust_rec_id,areacode,phone,sname,
                            address1,city,state,zip,
                            zip4,status,addi_status,call_date,
                            tsr,attempt_counter,company,fax,
                            annual_sales,no_of_employees,title,sic_code,
                            sic_description,naics_code,naics_description,
                            callback_name2,gate_keeper,email_to,
                            appt_date,appt_time,appt_name,email_date_sent,
                            email_type,acw_actionitem,acw_conf_dm,CallNotes,
                            CURDATE(),CURDATE()  
                            FROM " .  $tableName;
                            
                            DB::statement($insertStatement);
    }

    function insertDetbFile($tableName)
    {
        $insertStatement = "INSERT INTO cust_detb (cust_rec_id,note,
                                    company_id,contact_id,created_at,updated_at) 
                            SELECT 
                            cust_rec_id,note,company_id,contact_id,CURDATE(),CURDATE()
                            FROM " .  $tableName;
                            DB::statement($insertStatement);
    }

    function insertLogFile($tableName)
    {
        $insertStatement = "INSERT INTO cust_log (cust_rec_id,company_id,contact_id,
                                                log_date,log_notes,created_at,updated_at) 
                                                SELECT 
                                                cust_rec_id,company_id,contact_id,log_date,log_notes
                                                ,CURDATE(),CURDATE()
                                                FROM " .  $tableName;
                            DB::statement($insertStatement);
    }

    function createTable($uploadFile, $tableName)
    {
        $csvData = file_get_contents($uploadFile);
        $rows = array_map('str_getcsv', explode("\n", $csvData));
        // Skip the first row (header row)
        $header = array_shift($rows); 
        // Remove whitespace
        $header = array_map(function($element) {
            return str_replace(' ', '', $element);
        }, $header);
        // Remove special characters from each element
        $rows = array_map(function($element) {
            return preg_replace('/[^A-Za-z0-9\/\-]/', '', $element);
        }, $rows);
        $createTableQuery = 'CREATE TABLE ' . $tableName . ' (';

        foreach ($header as $columnName) {
            $createTableQuery .= ', ' . $columnName . ' TEXT'; // Adjust data types if needed
        }

        $createTableQuery .= ')';
        $createTableQuery = str_replace("(,","(",$createTableQuery);
        DB::statement($createTableQuery);
    }

    function trim_element($element) {
        return trim($element);
    }
}


